#include <tap.h>
#include "fileselect.h"

int initialize(void)
{
	return 0;
}

int _svcType, _svcNum, _eventNum;

TYPE_TapChInfo chInfo;

int TAP_main(void)
{
	char* p;
	int i,eventNum,nTvSvc,nRadioSvc;
	event_data_t* ed;

	TAP_Channel_GetTotalNum(&nTvSvc,&nRadioSvc);
	printf("Number of TV channels: %i, number of radio channels: %i\n",nTvSvc,nRadioSvc);

	TAP_Channel_GetCurrent( &_svcType, &_svcNum );
	printf("Service type=%i, Service Number=%i\n",_svcType, _svcNum);

	memset(&chInfo,1,sizeof(chInfo));

    TAP_Channel_GetInfo( _svcType, _svcNum, &chInfo );
	p=(char*)&chInfo;
/*
	for (i=0;i<sizeof(chInfo);i++) {
		if (p[i]==0)
			printf("%03i:  %i\n",i,p[i],p[i]);
		else
			printf("%03i:  %i  %c\n",i,p[i],p[i]);
	}
*/
	printf("Sattellite name: %s\n",chInfo.satName);
	printf("Channel name: %s\n",chInfo.chName);

	printf("Size of event_data_t struct: %i\n",sizeof(event_data_t));

	ed=TAP_GetCurrentEvent(_svcType,_svcNum);
	if (ed==NULL)
		printf("No EPG data available.\n");
	else {
		printf("Current event data:\n");
		printf("Event name: %s\n",ed->eventName);
		printf("Description: %s\n",ed->description);
		TAP_MemFree( ed );
	}
	eventNum=0;
	ed=TAP_GetEvent(_svcType,_svcNum,&eventNum);
	if (ed && eventNum>0) {
		for (i=0;i<eventNum;i++) {
			printf("Event nr %i%s:",i,ed[i].runningStatus & 4 ? " (current)" : "");
			printf(" %02d:%02d - %02d:%02d (%d:%02d h:min)\n",(ed[i].startTime>>8)&0xff,ed[i].startTime&0xff,
			                               (ed[i].endTime>>8)&0xff,ed[i].endTime&0xff,
			                               ed[i].duration/60,ed[i].duration%60);
			printf("servicenr: %i, event_id: %i\n",ed[i].service_number_and_flags,ed[i].event_id);
			printf("Event name: %s\n",ed[i].eventName);
			if (ed[i].description[0])
				printf("Description: %s\n",ed[i].description);
		}
		TAP_MemFree( ed );
	}
	return 0; /* 0 means return, 1 means stay TSR */
}


