#include "tap.h"

//TF4000 change
static api_table event_save;

static int _exitFlag = 0;
static int _epgShow = 0;
static word rgn;

void DrawLine( word rgn, int Ax, int Ay, int Bx, int By, int Color );

//TF4000 change
void setuserpalette(char* my_palette)
{
	DWORD* rgbq;	
	rgbq=(DWORD*)my_palette;

	rgbq[usercolorbase+0]=COLOR_u0;
	rgbq[usercolorbase+1]=COLOR_u1;
	rgbq[usercolorbase+2]=COLOR_u2;
	rgbq[usercolorbase+3]=COLOR_u3;
	rgbq[usercolorbase+4]=COLOR_u4;
	rgbq[usercolorbase+5]=COLOR_u5;
	rgbq[usercolorbase+6]=COLOR_u6;
	rgbq[usercolorbase+7]=COLOR_u7;
	rgbq[usercolorbase+8]=COLOR_u8;
	rgbq[usercolorbase+9]=COLOR_u9;
	rgbq[usercolorbase+10]=COLOR_u10;
	rgbq[usercolorbase+11]=COLOR_u11;
	rgbq[usercolorbase+12]=COLOR_u12;
	rgbq[usercolorbase+13]=COLOR_u13;
	rgbq[usercolorbase+14]=COLOR_u14;
	rgbq[usercolorbase+15]=COLOR_u15;
}

int _curIdx, _topIdx, _bottomIdx;
int _height;
TYPE_TapEvent *_evtInfo;
int _svcType, _svcNum, _eventNum;
int _maxSvcNum;

// --NEW: Last displayed info-index
unsigned int _old_topidx; 

char _strBuf[100];

#define X	90
#define Y	 80
#define W	530
#define H	500

#define MAX_LIST	10

void GetEvent(	int svcType, int svcNum )
{
	int i;

	if( _evtInfo )
	{
		TAP_MemFree( _evtInfo );
		_evtInfo = 0;
	}

	_evtInfo = TAP_GetEvent( svcType, svcNum, &_eventNum );

	_curIdx = 0;
	for( i=0; i<_eventNum; i++ )
	{
		if( _evtInfo[i].runningStatus == 4 )
		{
			_curIdx = i;
			break;
		}
	}

	if( _eventNum < MAX_LIST )
		_topIdx = 0;
	else
		_topIdx = _curIdx;
	_bottomIdx = _topIdx + (MAX_LIST-1);
	if( _bottomIdx >= _eventNum )
		_bottomIdx = _eventNum - 1;

}

void DrawEventDescr(void)
{

  TAP_Osd_FillBox( rgn, X, Y+350, W, 45, COLOR_User11 );
  TAP_SPrint( _strBuf, "%02d:%02d (%3d min)%s: %s\0",
    	(_evtInfo[_topIdx].startTime>>8) & 0xff, _evtInfo[_topIdx].startTime & 0xff,
        ((_evtInfo[_topIdx].duration>>8) &0xff)*60 + (_evtInfo[_topIdx].duration & 0xff) ,
        (_evtInfo[_topIdx].parentalRating == 0x10) ? "(16!)" : (_evtInfo[_topIdx].parentalRating == 0x12) ? "(18!)" : "\0", 
         _evtInfo[_topIdx].eventName);
  
  TAP_Osd_PutString1419( rgn, X+10+4, Y+350+2, X+W-4, _strBuf, COLOR_DarkBlue, COLOR_User11 );
  TAP_Osd_PutString1419( rgn, X+10+4, Y+350+22, X+W-4, _evtInfo[_topIdx].description, COLOR_Black, COLOR_User11 );

}

void DrawItem( int idx )
{
	int y;
	dword fc, bc;
    short year;
    char m,d,wday;

	y = 30 + (idx-_topIdx)*29;

	if( idx==_curIdx )
	{
		y+=3;
		fc = COLOR_Black;
		bc = COLOR_User11;
	}
	else
	{
		y+=3;
		fc = COLOR_Black;
		bc = COLOR_User8;
	}
    TAP_ExtractMjd((_evtInfo[idx].startTime>>16) & 0xffff, &year, &m, &d, &wday);
	

    TAP_SPrint( _strBuf, "     %02d:%02d ~ %02d:%02d",
	    (_evtInfo[idx].startTime>>8) & 0xff,_evtInfo[idx].startTime & 0xff,
		(_evtInfo[idx].endTime>>8) & 0xff,_evtInfo[idx].endTime & 0xff );
	TAP_Osd_PutString1622( rgn, X+2, Y+y+2, X+140, _strBuf, fc, bc );
    TAP_SPrint( _strBuf, " %02d.",d);
	TAP_Osd_PutString1419( rgn, X+1, Y+y+4, X+25, _strBuf, COLOR_Gray, bc );
	TAP_Osd_PutString1622( rgn, X+140+4, Y+y+2, X+W-4, "   ", fc, bc );
	TAP_Osd_PutString1622( rgn, X+140+10, Y+y+2, X+W-4, _evtInfo[idx].eventName, fc, bc );
    
	y+=26;

// NEW: Display InfoBox
    if (_topIdx != _old_topidx)
    {
      DrawEventDescr();
      _old_topidx = _topIdx;
    }
// --------------------
}


void DrawEvent(void)
{
	int i;
	for( i=_topIdx; i<=_bottomIdx; i++ )
	{
		DrawItem( i );
	}
}

void DrawEPG(byte refresh)
{
	int i, y;
	TYPE_TapChInfo chInfo;

	_old_topidx = 0xffff;
    
    if (!refresh) GetEvent( _svcType, _svcNum );

	TAP_Osd_FillBox( rgn, X, Y, W, 35, COLOR_User13 );

// NEW: InfoBox
   	  TAP_Osd_FillBox( rgn, X+10, Y+350+10, W, 45, COLOR_User1 );
	  TAP_Osd_FillBox( rgn, X, Y+350, W, 45, COLOR_User11 );
// ------------

	y = 30; 
	for( i=0; i<10; i++ )
	{
		TAP_Osd_FillBox( rgn, X, Y+y, W, 3, COLOR_User11 );
		TAP_Osd_FillBox( rgn, X, Y+y+1, W, 1, COLOR_User12 );
		y+=3;
		TAP_Osd_FillBox( rgn, X, Y+y, W, 26, COLOR_User8 );
		y+=26;
	}
	TAP_Osd_FillBox( rgn, X+140, Y+30, 2, y-30, COLOR_User12 );

	TAP_Osd_DrawRectangle( rgn, X, Y, W, y, 1, COLOR_User12 );
	TAP_Osd_DrawRectangle( rgn, X-1, Y-1, W+2, y+2, 1, COLOR_User10 );
	TAP_Osd_FillBox( rgn, X+W+1, Y+10, 10, y, COLOR_User1 );
	TAP_Osd_FillBox( rgn, X+10, Y+y+1, W, 10, COLOR_User1 );

	TAP_Osd_PutStringAf1926( rgn, X+5, Y+4, -1, "Quick EPG", COLOR_DarkBlue, COLOR_Nodraw );

	TAP_Channel_GetInfo( _svcType, _svcNum, &chInfo );
    sprintf(_strBuf,"%d - %s\0", _svcNum+1, chInfo.chName);
	TAP_Osd_PutStringAf1926( rgn, X+145, Y+4, X+W-4, _strBuf, COLOR_DarkCyan, COLOR_Nodraw );

	DrawEvent();
}

dword TAP_EventHandler( word event, dword param1, dword param2 )
{
	int r, t;
	dword mainState, subState;
    static unsigned int refresh_epg=0;
    
    if( event != EVT_KEY )
     {
        if((_epgShow) && (refresh_epg) && (TAP_GetTick() > refresh_epg))
        {
          if (_eventNum == 0) refresh_epg = TAP_GetTick() + 200;
            else refresh_epg = 0;
          
          DrawEPG(0);
          if (_eventNum == 0) refresh_epg = 0;
          
        }
        return param1;
     }
	// TF4000 change:
	mainState=TAP_GetState(0);
	subState=0;
    
    if( mainState != STATE_Normal )
    {
        return param1;
    }

    if( _epgShow==0 )
    {
		if( param1 == RKEY_Guide )
		{
			char* my_palette;

			// TF4000 change
	        my_palette = malloc(1024);
    	    if (!my_palette) return 0;

			_epgShow = 1;
			TAP_ExitNormal();

			// TF4000 change
			rgn = 0;
	        TAP_GetDefaultPalette(my_palette);
	        TAP_Osd_Delete(rgn);  // only that window!
	        TAP_Osd_Create(rgn, 0, 0, 720, 576,256,2);
			setuserpalette(my_palette);
    	    TAP_Osd_SetLut(2, my_palette, 16);
        	TAP_Osd_Ctrl(rgn, 1);
   
	        free(my_palette);
			// TF4000 change end

			TAP_Channel_GetCurrent( &_svcType, &_svcNum );
			TAP_Channel_GetTotalNum( &t, &r );
			if( _svcType == SVC_TYPE_Tv )
				_maxSvcNum = t;
			else
				_maxSvcNum = r;
			DrawEPG(0);
			return 0;
		}
        ef( param1 == RKEY_0 )
    	{
			if (_evtInfo)
				TAP_MemFree( _evtInfo );
			// TF4000 changes:
			__entrytable__[0x30 / 4] = event_save;
			TAP_ClearCallback();
			TAP_Exit();
			return 0;
    	}
		return param1;
    }            
        
	switch( param1 )
	{
		case RKEY_Guide :
		case RKEY_Exit	:
			if( _epgShow )
			{
				_epgShow = 0;
				TAP_Osd_Delete(rgn);
                
				TAP_EnterNormal();
			}
            break;

		case RKEY_VolUp :
			_svcNum = (_svcNum+1) % _maxSvcNum;
            DrawEPG(0);
			//TAP_Channel_Start( _svcType, _svcNum );
			break;

		case RKEY_VolDown :
			_svcNum = (_svcNum+_maxSvcNum-1) % _maxSvcNum;
			DrawEPG(0);
			//TAP_Channel_Start( _svcType, _svcNum );
			break;

		case RKEY_ChUp :
			_topIdx--;
			if( _topIdx<0 )
				_topIdx = 0;
			else
			{
				_bottomIdx = _topIdx + (MAX_LIST-1);
				if( _bottomIdx >= _eventNum )
					_bottomIdx = _eventNum - 1;
				TAP_Osd_Copy( rgn, rgn, X, Y+30, W, 29*9, X, Y+30+29, FALSE );
				DrawItem( _topIdx );
			}
			break;

		case RKEY_ChDown :
			_bottomIdx++;
			if( _bottomIdx >= _eventNum )
				_bottomIdx = _eventNum - 1;
			else
			{
				_topIdx++;
				TAP_Osd_Copy( rgn,rgn, X, Y+30+29, W, 29*9, X, Y+30, FALSE );
				DrawItem( _bottomIdx );
			}
			break;
		case RKEY_Ok	:             // NEW: Refresh the EPG
                     if (_eventNum == 0)   
                     { 
       	               TAP_Osd_PutString1622( rgn, X+145+10, Y+30+4, X+W-4, "Getting info. Please wait...", COLOR_Black, COLOR_User8 );
                       TAP_Channel_Start(0, _svcNum);
                       refresh_epg = TAP_GetTick() + 350;  // refresh after 1500ms
                     }
                     else DrawEPG(0);
            break;
            
	}

	return 0;
}

// TF4000 change
int initialize(void)
{
	return 0;
}

// TF4000 change
static int event_handler(int code)
{
	return TAP_EventHandler( EVT_KEY, code, 0 );
}

// TF4000 change
static int tsr_handler(int code)
{
	TAP_EventHandler( EVT_IDLE, code, 0 );
	return code;
}

// TF4000 change
int TAP_main(void)
{
	_evtInfo=NULL;

	event_save = __entrytable__[0x30 / 4];
	__entrytable__[0x30 / 4] = event_handler;

   //	MsgBox_Window_Nummer = rgn;
    TAP_SetTSRCallback(tsr_handler);
    
	return 1;
}

