/* Preliminary TAP definitoins */
/* Version 0.31 from October 8th, 2003. */

/* The API prototypes are incomplete and for sure have bugs */

/* No copyright, this is public domain; you may do whatever you want with it */
/* No warranties, it will destroy your equipment and then your life! */

/* My typedefs are not 100% perfect, they might need this #pragma on PowerPC */
#pragma pack(0)

/* The 0.3 release was modeled after the TF5000 API. All functions have
   been renamed to reflect the TF5000 names. The old names are still there
   for compatibility reasons.
   It's recommended to use the firmware from September 26 or later.
*/

/* The 0.2 release contains a part of newlib and associated headers.
   We can therefore take advantage of that here.
*/

/* This can be used to create source for both receivers, using #ifdef blocks */
#define Topfield4000

#include <string.h>
#include "type.h"
#include "key.h"
#include "hdd.h"
#include "win.h"
#include "font.h"


/* Defines related to event handling. Most notably, codes from remote
   control are listed here. These are being used in the RemoteControl callback.
*/

// Ghisler: default colors

#define COLOR_None 0
#define COLOR_Black 1
#define COLOR_DarkRed 2
#define COLOR_DarkGreen 3
#define COLOR_DarkYellow 4
#define COLOR_DarkBlue 5
#define COLOR_DarkMagenta 6
#define COLOR_DarkCyan 7
#define COLOR_Gray 8
#define COLOR_Red 9
#define COLOR_Green 10
#define COLOR_Yellow 11
#define COLOR_Blue 12
#define COLOR_Magenta 13
#define COLOR_Cyan 14
#define COLOR_White 15

#define COLOR_DarkGray 8

// This is used on the TF4000 as a Text draw background color so nothing is drawn
#define COLOR_Nodraw 0xFF

#define usercolorbase 20

// User defined Colors
#define COLOR_User0 usercolorbase+0
#define COLOR_User1 usercolorbase+1
#define COLOR_User2 usercolorbase+2
#define COLOR_User3 usercolorbase+3
#define COLOR_User4 usercolorbase+4
#define COLOR_User5 usercolorbase+5
#define COLOR_User6 usercolorbase+6
#define COLOR_User7 usercolorbase+7
#define COLOR_User8 usercolorbase+8
#define COLOR_User9 usercolorbase+9
#define COLOR_User10 usercolorbase+10
#define COLOR_User11 usercolorbase+11
#define COLOR_User12 usercolorbase+12
#define COLOR_User13 usercolorbase+13
#define COLOR_User14 usercolorbase+14
#define COLOR_User15 usercolorbase+15

typedef struct {
	char r,g,b,i;
} type_rgbquad;

#define RGB(r,g,b)	  	( ((r)<<24) | ((g)<<16) | ((b)<<8) | 1 )
#define RGBI(r,g,b,i)	  	( ((r)<<24) | ((g)<<16) | ((b)<<8) | (i) )

#define COLOR_u0 RGB(0,  16,  64)
#define COLOR_u1 RGB(12,  28,  76)
#define COLOR_u2 RGB(24,  44,  88)
#define COLOR_u3 RGB(36,  56, 100)
#define COLOR_u4 RGB(48,  72, 112)
#define COLOR_u5 RGB(60,  84, 124)
#define COLOR_u6 RGB(72,  96, 136)
#define COLOR_u7 RGB(84, 112, 148)
#define COLOR_u8 RGB(96, 124, 164)
#define COLOR_u9 RGB(112, 140, 176)
#define COLOR_u10 RGB(132, 156, 188)
#define COLOR_u11 RGB(156, 176, 200)
#define COLOR_u12 RGB(180, 196, 216)
#define COLOR_u13 RGB(200, 216, 228)
#define COLOR_u14 RGB(224, 232, 240)
#define COLOR_u15 RGB(248, 252, 252)

/* Note: To use these colors, use the following code:
void setuserpalette(char* my_palette)
{
	DWORD* rgbq;	
	rgbq=(DWORD*)my_palette;

	rgbq[usercolorbase+0]=COLOR_u0;
	rgbq[usercolorbase+1]=COLOR_u1;
	rgbq[usercolorbase+2]=COLOR_u2;
	rgbq[usercolorbase+3]=COLOR_u3;
	rgbq[usercolorbase+4]=COLOR_u4;
	rgbq[usercolorbase+5]=COLOR_u5;
	rgbq[usercolorbase+6]=COLOR_u6;
	rgbq[usercolorbase+7]=COLOR_u7;
	rgbq[usercolorbase+8]=COLOR_u8;
	rgbq[usercolorbase+9]=COLOR_u9;
	rgbq[usercolorbase+10]=COLOR_u10;
	rgbq[usercolorbase+11]=COLOR_u11;
	rgbq[usercolorbase+12]=COLOR_u12;
	rgbq[usercolorbase+13]=COLOR_u13;
	rgbq[usercolorbase+14]=COLOR_u14;
	rgbq[usercolorbase+15]=COLOR_u15;
}
*/

/* Start with the basics */

typedef char int8_t;
typedef unsigned char u_int8_t;
typedef u_int8_t BYTE; /* alias for Windows programmers */
typedef short int16_t;
typedef unsigned short u_int16_t;
typedef u_int16_t WORD; /* alias for Windows programmers */
typedef int int32_t;
typedef unsigned int u_int32_t;
typedef u_int32_t DWORD; /* alias for Windows programmers */
typedef long long int64_t;
typedef unsigned long long u_int64_t;
typedef u_int64_t qword; /* alias */
typedef u_int64_t QWORD; /* alias for Windows programmers */
typedef int32_t register_t;

// for compatibility with TF5000

#define EVT_IDLE                0x000   // param1 = none, param2 = none
#define EVT_KEY                 0x100   // param1 = keyCode, param2 = none
#define EVT_UART                0x200   // param1 = data

// The TF4000 only returns these two
#define STATE_Normal 1
#define STATE_Menu   0

typedef enum
{
	SVC_TYPE_Tv,
	SVC_TYPE_Radio,
} TYPE_ServiceType;

#define MAX_SatName 	15            // Tested: One less than on the TF5000!!!
#define MAX_SvcName 	((4*7-1)-4)   // Tested: 23 bytes

typedef struct
{
	char    satName[ MAX_SatName ];   // Name of satellite, e.g. Astra
	char    chName[ MAX_SvcName ];    // Name of channel, e.g. Arte
	byte	flag;                     // byte 39: unknown contents
	byte	polar;                    // byte 40: 64 for V, 96 for H ???
	byte	tunerNum;                 // byte 41: seems to be always 0
	word	freq;                     // byte 42 and 43: frequency in MHz, high byte first
	word	sr;                       // byte 44 and 45: signal rate
	word	svcId;                    // rest seems to be OK
	word	pmtPid;
	word	pcrPid;
	word	videoPid;
	word	audioPid;                 // high bit seems to be a flag, so & it with 0x7FFF for the audio pid
	byte	volume;                   // always 0 on TF 4000, but field is actually set to 0!
	byte	soundMode;                // always 0 on TF 4000, but field is actually set to 0!
} TYPE_TapChInfo;

//----------------------------------------------------------------------------
/* The following types are derived from the DVB standards and should not depend
   on how Topfield implements them. They have been derived directly from the
   relevant ETSI documentation. The field names are mostly verbatim from the
   standards texts. They work OK on big-endian processor such as the
   PowerPC in the TF4000PVR, do not try to use them directly under
   Windows, as the x86 is a little-endian architecture.
*/

/* Transport Stream (TS) packets, the form the basis of TF recording files. */

#define	TS_SYNC	0x47 /* Sync byte, starts every TS packet */

typedef struct {
	u_int32_t sync_byte:8;
	u_int32_t transport_error_indicator:1;
	u_int32_t payload_unit_start_indicator:1;
	u_int32_t transport_priority_indicator:1;
	u_int32_t pid:13;
	u_int32_t transport_scrambling_control:2;
	u_int32_t adaptation_field_control:2;
	u_int32_t continuity_counter:4;
	u_int8_t data[184];
} ts_packet;

/* Topfield internal structures, grossly incomplete and volatile to change.
   Do not use these unless you actually must. You have been warned.
*/

typedef struct {
	u_int8_t	sat;
	u_int8_t	polarity;
	u_int16_t	frequency;
	u_int16_t	symbolrate; /* in kS/s */
	u_int16_t	network_id;
} transponder_description_t;

typedef struct {
	u_int16_t	service_number_and_flags;    /* bit 26 - radio/TV */
	u_int16_t	event_id;
	u_int32_t	startTime;                // loword: hibyte=hours, lobyte=minutes
	u_int32_t	endTime;                  // see start_time   
	u_int16_t	duration;                 // in minutes
	u_int8_t	runningStatus;            // if running_status & 4 =! 0 then current 
	char		eventName[128];           // starting at byte 16, but only 126 chars!
	char		description[128];         // starting at byte 144
	byte	    parentalRating;             // parental Rating  0x10= 16 years  0x12= 18 years
} event_data_t;

#define TYPE_TapEvent event_data_t

typedef struct {
	u_int16_t	service_number_and_flags; /* bit 26 - radio/TV */
	u_int16_t	event_id;
	u_int32_t	start_time;
	u_int32_t	end_time;
	u_int16_t	duration;
	u_int8_t	running_status;
	u_int8_t	length_of_name;
	char		name_of_event_and_description[130];
	u_int16_t	service_ID;
	u_int32_t	field_94;
} event_data_recording_t;	/* sizeof = 0x98 = 152 */ 

typedef struct {
	u_int32_t	end_date_time_1;
	u_int32_t	end_date_time_2;
	u_int16_t	duration; /* in minutes */
	u_int16_t	service_number;
	u_int16_t	service_flags; /* also event ID? */
	u_int8_t	tuner;
	u_int8_t	field_F;
	u_int16_t	transponder_index_and_flags;
	u_int16_t	svc_ID;
	u_int16_t	pmt_PID;
	u_int16_t	pcr_PID;
	u_int16_t	video_PID;
	u_int16_t	audio_PID;
	char		service_name[24];
	transponder_description_t	transponder_description;
	event_data_recording_t	event_data;
} recording_header_t; /* length = 0xd4 = 212 */

typedef struct {
	u_int8_t	type;	/* 0 */
	u_int8_t	data[7]; /* 1 */
	u_int32_t	start_block; /* 8 */
	u_int32_t	count_of_blocks; /* C */
	u_int32_t	empty_in_last_block; /* 10 */
	char		name[108]; /* 14 */
} directory_entry_t; /* sizeof = 0x80 = 128 */

#define	MENU_MAX_LINES	2000

typedef struct {
	int something[0x48 / 4]; /* Not known yet */
	char *texts;
	char *item_texts[MENU_MAX_LINES];
	char item_byte[MENU_MAX_LINES];
	short item_word[MENU_MAX_LINES];
	int number_of_lines;
	int field_0x3700;
	int current_choice;
	int visible_lines;
	char font_script, font_size, field_0x370e, field_0x370f;
} menu_t;

typedef	u_int32_t bookmarks_t[64];

/* The TAP API calls and helpers. This has no relation to the yet
   unreleased TAP API documentation by Topfield.
   The Topfield names will inevitably be different.
*/

typedef	int (*api_table)();
typedef	int (*t_tap_callback)(int);   /* parameters may be different */

/* **************************************************************************** */
/* The TAP API invocation mechanism */
/* **************************************************************************** */

#define	TAP_API(number, return, parameters) \
	(*((return (*)parameters)(__entrytable[number / 4])))

/* This API should be called periodically in TAP applications during
   long processing, provided that the application has defined
   some of the callbacks. It will process console or remote events
   through these callbacks, otherwise the events will be sitting
   there and not processed.
*/

/* **************************************************************************** */
/* **************************************************************************** */

/* call to handle system events */
#define	TAP_SystemProc	TAP_API(0x28, void, (void))

/* value must be set to zero. Retval is 0 if in any menu, 1 otherwise (if no GUI shown or only status) */
#define	TAP_GetState	TAP_API(0x34, int, (int value))

/* This function MUST be called before drawing anything on screen!  It lets the receiver hide all its own onscreen displays */
#define	TAP_ExitNormal	TAP_API(0x38, void, (void))

/* This function MUST be called when hiding all windows from the screen!  It lets the receiver show again all its own onscreen displays */
#define	TAP_EnterNormal	TAP_API(0x3c, void, (void))

/* This sets a TSR callback routine, which is called in the main event loop.
   Once a TSR returns control from TAP_main back to main firmware, it is
   periodically called through this callback. Non-TSR TAPs should never
   set this callback, TSR have to set this callback to work.
   not in TF5000 API because the implementation is different  */
#define	TAP_SetTSRCallback	TAP_API(0x40, int, (t_tap_callback))

/* Clear a callback previously defined with TAPSetTSRCallback
   not in TF5000 API because the implementation is different */
#define	TAP_ClearCallback	TAP_API(0x44, void, (void))

/* Non-TSR TAPs are terminated by simply returning 0 from TAP_main. TSRs
   return non-0 in TAP_main and are kept in memory until they request
   termination by this API call. Note: you may have only 1 TAP active
   at any time, ie. if you are running a TSR, no other TAP application
   (non-TSR or TSR) can be invoked. This is bad and I hope that TF will fix it. */
#define	TAP_Exit	TAP_API(0x48, void, (void))

/* **************************************************************************** */
/* CONSOLE I/O */
/* **************************************************************************** */

/* The console uses 115200 8N1, no flow control. Sustained 115200 bps throughput
   seems to be impossible due to loading with other tasks, interurpts etc.
   Output is polled, input is interrupt driven with a small queue.
   You can either check/read from console directly, or you can rely on the
   callback mechanism (good for TSRs or applications able to handle
   asynchronous events.                                                         */

/* Check if char available from the console, if so, return non-0, else return 0. */
#define	TAP_KbHit	TAP_API(0x4c, int, (void))

/* Busy wait for character from console, return it. If TAP_KbHit() returned non-0,
   next call to ConsoleReadChar() returns immediately. */
#define	TAP_GetCh	TAP_API(0x50, char, (void))

/* Write 1 char to the console, polled without interrupts. No CR-LF or other
   translation, OK for raw data.   */
#define	TAP_PutCh	TAP_API(0x54, void, (char))

/* Console printf, formats the parameters and outputs the string. The
   format buffer is 256 bytes, so never write anything which
   might produce more than 256 bytes after formatting!!! This would
   destroy the stack frame and crash the whole system.
   You should set your terminal so that \n (linefeed) does CR and LF.*/
#define	TAP_Print	TAP_API(0x58, void, (char *format, ...))

/* **************************************************************************** */
/* Graphics API.
   The IBM processor used in TF has a built-in display controller.
   I do not have details to the programming interface, but seems to be
   able to display several overlays with different modes each etc.
   I am not sure about any HW acceleration.
   Topfield uses mainly full-screen windows (720x576) in 256 colours,
   where each pixel has 1 byte. The colours are defined using a palette,
   which is 256 items of 4 bytes each (my guess: R, G, B and transparency?).
   The pixel value is the index into the palette structure.

   The 720x576 is the size for PAL system, for NTSC there are only
   476 lines. The y coordinates are automatically corrected
   unless you use one of the special APIs which do not correct the y
   coordinates. Typically you can use the 720x576 area.
   Be careful that the borders may not be visible on some TV sets.

   The TF has 3 layers of graphics objects: the lowest level is "frames"
   (my term), which correspond to HW obejcts.

   Frames are abstracted to "windows", which have their own coordinate system.
   There are 32 "windows", numberred 0..31.

   For some graphics objects (menus, ...) there are higher-level calls, but
   a lot is still done with the basic WindowXXX calls even in the TF firmware. */
/* **************************************************************************** */

/* Create a window with upper-left corner at (x,y) with size (w,h) pixels.
   The window uses "colours" colours. The last parameter meaning is yet
   to be detrmined, I have seen value 2 in Topfield original TAP applications.
   It might the be frame number to be used.

   From TF5000 API, it seems to be the lutIdx parameter (index to palette table),
   must be the same as first parameter in WindowSetPalette      */
#define	TAP_Osd_Create	TAP_API(0xdc, int, (int rgn, int x, int y, int w, int h, int colours, int lutIdx))

#define WINDOW_ALL	0xff

/* Clears window (window = 0..31) or all windows (window=WINDOW_ALL) */
#define	TAP_Osd_Delete	TAP_API(0xe0, int, (int rgn))

/* From TF5000 API, it must be TAP_Osd_Move <- untested! */
#define	TAP_Osd_Move	TAP_API(0xe4, int, (int rgn, int x, int y))

/* Fills a defined region of window with constant pixel value */
#define	TAP_Osd_FillBox	TAP_API(0xe8, int, (int rgn, int x, int y, int w, int h, int colour))

/* Paint a pixmap (overwrite any data already in that part of the window) */
#define	TAP_Osd_PutBox	TAP_API(0xec, int, (int rgn, int x, int y, int w, int h, void *pixmap))

/* Get a pixmap from window into normal memory */
#define	TAP_Osd_GetBox	TAP_API(0xf0, int, (int window, int x, int y, int w, int h, void *bitmap))

/* Define the palette for frame (?). First parameter is the frame number (?)
   [use 2 in TAP applications], second is the pointer to palette, the
   last paramter is unknown (TF TAP applications use 16).
   TF5000: There is no third parameter...                                 */
#define	TAP_Osd_SetLut	TAP_API(0xf4, int, (int lutIdx, void *lut, int unknown))

/* Activates the frame for the window. The first paramter is the window
   number to be activated, the second is the mode (either 0 or 1,
   TAP applications use 1).    */
#define	TAP_Osd_Ctrl	TAP_API(0xf8, int, (int rgn, int mode))

/* Set transparency of OSD, from 0 to 100 (in percent) */
#define TAP_Osd_SetTransparency	TAP_API(0xfc, int, (word rgn, char rt))

/* Draws a (hollow) rectangle with 2 pixels thick lines. Upper and left
   borders may have different colour than the bottom and right borders
   for 3D look.      */
#define	TAP_Osd_Draw3dBox	TAP_API(0x100, void, (int window, int x, int y, int w, int h, int colour_upper_left, int colour_bottom_right))

/* Draws a (filled) box, framed with 2-pixel thick borders. The colours
   of the border are as above with WindowDrawRectangle(). */
#define	TAP_Osd_Draw3dBoxFill	TAP_API(0x104, int, (int window, int x, int y, int w, int h, int colour_upper_left, int colour_bottom_rigth, int colour_inside))

/* not tested yet! */
#define	Api_108	TAP_API(0x108, void, (int window, int, int, int, int, int, int))

/* draw a rectangle */
#define	TAP_Osd_DrawRectangle TAP_API(0x108, int,(word rgn, dword x, dword y, dword w, dword h, dword t, dword color))

/* not tested yet! */
#define	Api_10c	TAP_API(0x10c, int, ((int window, int, int, int, int, int, int, int))
#define	Api_110	TAP_API(0x110, int, (int window, int, int, int, int, void *bitmap))
#define	TAP_Osd_DrawPixmap TAP_API(0x110, int,(word rgn, dword x, dword y, dword w, dword h, void *pixmap, bool sprite, byte dataFormat ))
#define	Api_114	TAP_API(0x114, int, (int window, int, int, int, int, int))
//------------

/* Paint a pixmap which is RLE (Run Length Encoding) compressed. Most pixmaps
   internally used in TF firmware are RLE encoded. Details of the encoding
   will be available later, but it might be compatible with other systems.*/
#define	WindowPaintRLEPixmap	TAP_API(0x118, int, (int window, int x, int y, int w, int h, void *pixmap))

/* As above, but the pixmap is transparent. */
#define	WindowPaintTransparentRLEBitmap	TAP_API(0x11c, int, (int window, int x, int y, int w, int h, void *pixmap))

/* Sorry, not yet. */
#define	Api_120	TAP_API(0x120, int, (int, int, int, int))
#define	Api_124	TAP_API(0x124, int, (int, int, int, int))

/* Copy a region of window to another place of window */
#define	TAP_Osd_Copy	TAP_API(0x128, int, (int window1, int window2, int x, int y, int w, int h, int, int, int))

/* From TF5000 API: this is probably TAP_Osd_SaveBox */
#define	TAP_Osd_SaveBox	TAP_API(0x12c, char*, (int window, int x, int y, int w, int h))

/* As with other pixmap ops, but without resizing for NTSC different aspect ratio. */
#define	TAP_Osd_RestoreBox	TAP_API(0x130, int, (int window, int x, int y, int w, int h, char *bitmap))

/* Get 1 pixel value from window, store result via pointer */
#define	TAP_Osd_GetPixel	TAP_API(0x134, int, (int window, int x, int y, void *))

/* Set 1 pixel in window */
#define	TAP_Osd_PutPixel	TAP_API(0x138, int, (int window, int x, int y, int colocour))

/* Copy the default palette into 1024 byte long buffer. Typically,]	 :  byte lux[256][4]
   you get a default palette and then set it for window, possibly
   after modification. */
/* This function seems to be TF4000-specific */

#define	TAP_GetDefaultPalette	TAP_API(0x13c, void, (void *))

/* **************************************************************************** */
/* FILE I/O for disk files.
   **************************************************************************** 

   The HDD uses a FAT-like filesystem with files and hierarchical directories.
   The format of the filesystem is proprietary and the functionality is quite
   limited. There are also bugs in some of the file operations, if you use them
   for general purpose things.
   There is no block-level bufferring done in the system, so every
   FileWrite crossing sector (512 bytes) boundary does a read-modify-write.
   Disk I/O is principally polled, there is a busy wait loop for the ATA
   interrupt. The performance is quite bad. For recording/playback, TF uses
   DMA-based transfers, but these are not exported as API. For a video
   recording file, even with 64K buffering, reading it takes usually
   longer than the real-time playback of the file.
   For files > MAXINT, lots of the API do not work (ie seek), as they
   use only 32bits for offsets. It is possible to handle large files,
   but only by directly manipulating the FCBs. This API uses opaque
   handles to identify files, the real implementation is that
   the file handle is actually a pointer to FCB structure.
   You cannot open the same file twice.
   Writing files > 1MB results in incorrect length, you can fix this
   by manipulating the FCB directly.
   Every file has a type which is recorded in the first byte of the
   direntry_t. See the manifest constants for a full list of values
   used by TF firmware.

   Files consist of 1MB allocation blocks, so any file (including directories)
   takes a whole number of megabytes on the disk.
*/

/* Open an existing file within current directory, return file handle or
   0 if file not found or cannot be opened (ie. already open). */
#define	TAP_Hdd_Fopen TAP_API(0x168, TYPE_File*,( char *name ))

/* Read from file into buffer, return "count" if successful, 0 otherwise.
   The number of bytes actually read is size*count.*/
#define	TAP_Hdd_Fread  TAP_API(0x16c, dword,( void *buf, dword blksize, dword blk, TYPE_File *file ))

/* Write size*count bytes into file from current position. The file
   length is correctly extended up to 1MB, beyond that the length is
   OK in terms of megabytes, but the number of bytes in the last
   1MB block is incorrect. */
#define	TAP_Hdd_Fwrite TAP_API(0x170, dword,( void *buf, dword blksize, dword blk, TYPE_File *file ))

/* Close an open file, deallocate the FCB. Will crash the system if handle
   is not a FCB pointer! */
#define	TAP_Hdd_Fclose TAP_API(0x174, void,( TYPE_File *file ))

/* Opens the current directory for traversal item by item. Returns
   number of files in the directory (or 0 if error). The argument
   has to be a pointer to directory_entry_t structure, which is filled
   with the first valid file. Next file is obtained by calling FileReadDir()
   with the same argument, until 0 is returned from the FileReadDir() call.
   (TF uses both counting over the number of files as returned from this
   call and checking the result of FileReadDir(), but a loop like:

   if (TAP_Hdd_FindFirst(&TYPE_File))
      do {
        process_the_entry();
      } while (TAP_Hdd_FindNext(&TYPE_File));

   seems to work as well.

   I afraid that you can enumerate only 1 directory at a time (globally).*/
#define	TAP_Hdd_FindFirst TAP_API(0x178, dword, ( TYPE_File *file ))

/* Read from file into buffer, return "count" if successful, 0 otherwise.
   The number of bytes actually read is size*count.*/
#define	TAP_Hdd_FindNext TAP_API(0x17c, dword,( TYPE_File *file ))

/* Set the current file position to offset, therefore this is OK only
   for files up to 4GB.*/
#define	TAP_Hdd_Fseek TAP_API(0x180, dword, (TYPE_File *file, long pos, long where))


/* Get a size of the file in bytes. Does not work for files > 4GB and returns
   incorrect results for files longer than 1 MB unless the length has been fixed
   during writing. */
#define	TAP_Hdd_Flen       TAP_API(0x184, dword,( TYPE_File *file ))

/* Get the current file position, works only for positions < 4GB */
#define	TAP_Hdd_Ftell   TAP_API(0x188, dword,( TYPE_File *file ))

/* Return the number of megabytes on the whole disk */
#define	TAP_Hdd_TotalSize       TAP_API(0x18c, dword, (void))

/* Return the number of available (free) disk blocks (1MB) on the disk */
#define	TAP_Hdd_FreeSize            TAP_API(0x190, dword, (void))

/* Delete an existing file */
#define	TAP_Hdd_Delete TAP_API(0x194, word,( char *name ))

/* Test if the file exists in the current directory.
   Returns 1 (file exists) or 0 (file does not exist). */
#define TAP_Hdd_Exist       TAP_API(0x198, bool, (char *name))

/* Create a new file without opening it. Fails if file exists. */
#define TAP_Hdd_Create TAP_API(0x19c, dword, (char *name, byte attr))

/* Select current directory (global setting for whole system).
   When TAP application is started, the current directory is the root directory,
   which is called "__ROOT__" in TF. If you change to a subdirectory (such as
   "__PROGRAM__" where TF keeps the TAP applications and files downloaded via
   TAP data download function), you can get to upper level by "__PARENT__".
   The API call translates some usual UNIX names (/, ..) to their TF
   variant.
   Remember: you cannot use paths to open files in subdirectories, ie. to
   open a file "/__PROGRAM__/hello.tap" you have to FileChdir to __PROGRAM__ and
   open a file called "hello.tap" there, then FileChdir back to __ROOT__. The
   slash ("/") and backslash ("\\") are normal characters which can appear in
   file names.*/
#define TAP_Hdd_ChangeDir TAP_API(0x1a0, word, (char *dir))

/* **************************************************************************** */
/* TEXT GUI OUTPUT */
/* **************************************************************************** */


/* Draw text: fntType must be 0, fntSize must be 0..2 */
/* bDot: if set, show "..." at string end if too long */
/* align: align method. ALIGN_LEFT, ALIGN_CENTER or ALIGN_RIGHT */

#define	TAP_Osd_PutS	TAP_API(0x1cc, int, (int window, int x, int y, int maxX, const char* str,int forecolor, int backcolor, int fntType, int fntSize, byte bDot, byte align))

/* Get string width, in pixels */

#define	TAP_Osd_GetW   TAP_API(0x1d0, int, (const char *str, byte fntType, byte fntSize ))

/* Draw text: fntType must be 0, fntSize must be 0..2 */
/* maxX is the maximum X coordinate, NOT the max. string length! Set to -1 for unlimited */

#define	TAP_Osd_PutString	TAP_API(0x1d4, int, (int window, int x, int y, int maxX, const char* str,int forecolor, int backcolor, int fntType, int fntSize, int nextLine))

/* May be TAP_Osd_DrawString and TAP_Osd_PutStringAf */
#define	Api_1d8	TAP_API(0x1d8, int, ())
#define	Api_1dc	TAP_API(0x1dc, int, ())
//#define	TAP_Osd_DrawString	TAP_API(0x1d8, int, (const char * str, dword dstWidth, word color, byte * dest, dword maxWidth, byte fntType, byte fntSize))
/* WARNING: TAP_Osd_PutStringAf tested, does NOT work, crash receiver      */
//#define	TAP_Osd_PutStringAf	TAP_API(0x1dc, int, (word rgn, dword x, dword y, dword maxX, const char * str, word fcolor, word bcolor, byte fntType, byte fntSize, byte nextLine))

/* Tested. */
#define	TAP_SetSoundLevel	TAP_API(0x84, int, (char soundLevel))

/* **************************************************************************** */
/* Miscellaneous functions */
/* **************************************************************************** */

/* Get current date and time */
#define	TAP_GetTime	TAP_API(0x88, int, (short *MJD_date, char *hour, char *minute, char *second))

/* Get heap information */
#define	TAP_MemInfo	TAP_API(0x8c, int, (int *heapSize, int *freeHeapSize, int *availHeapSize))

/* Allocate a block of memory */
#define	TAP_MemAlloc	TAP_API(0x90, void *, (int size))

/* Free a previously allocated block */
#define	TAP_MemFree	TAP_API(0x94, int, (void *ptr))

/* get ticks since boot time, as a multiple of 10 milliseconds */
#define	TAP_GetTick	TAP_API(0x98, int, (void))

/* delay multiple of 10 milliseconds */
#define	TAP_Delay	TAP_API(0x9c, int, (int dm10))

/* Extract year, month and day from value returned by TAP_GetTime */
#define	TAP_ExtractMjd TAP_API(0xa0, int, (short MJDDate, short *year, char *month, char *day, char *weekday))

/* build structure from year, month and day */
#define	TAP_MakeMjd	TAP_API(0xa4, int, (short year, char month, char day))

/* Fixed point arithmetics to help drawing circles */
/* The alpha angle is in degrees */
/* This is used ie. in the Topfield CLOCK example to draw the hands
   and in some of the games*/
#define	TAP_Sin	TAP_API(0xa8, int, (int x, int alpha))
#define	TAP_Cos	TAP_API(0xac, int, (int x, int alpha))

/* Limited sprintf (no floating point support */
#define	TAP_SPrint	TAP_API(0xb0, int, (char *buffer, char *format, ...))

/* These two are the signal level functions: Get signal level+quality for current channel */
#define	TAP_GetSignalLevel	TAP_API(0xb4, int, ())
#define	TAP_GetSignalQuality	TAP_API(0xb8, int, ())

/* **************************************************************************** */
/* High level graphics - menus */
/* Still incomplete */
/* **************************************************************************** */

/* It draws the title of window. */
#define	TAP_Win_SetTitle    TAP_API(0x1e0, void, (TYPE_Window *win, const char *str, byte fntType, byte fntSize))

/*  Not tested yet! TAP_Win_SetColor */
#define	TAP_Win_SetColor	    TAP_API(0x1e4, void, (TYPE_Window *win, word titleBack, word titleText, word bodyBack, word bodyText, word border, word shadow, word dark, word light))

/* Set default window colors */
#define	TAP_Win_SetDefaultColor	TAP_API(0x1e8, void, (TYPE_Window *win))

/* Draw the window */
#define	TAP_Win_Draw	        TAP_API(0x1ec, void, (TYPE_Window *win))

/* TAP_Win_Create sets the basic parameters of window and draws it on the screen. */
/* save : It decides to save the background image before the window is drawn.     */
/* bScr : It decides to show the scroll bar.                                      */
#define	TAP_Win_Create	TAP_API(0x1f0, void, (TYPE_Window *win, word rgn, dword x, dword y, dword w, dword h, byte save, byte bScr))

/* Delete the window */
#define	TAP_Win_Delete	TAP_API(0x1f4, dword, (TYPE_Window *win))

/* Set window font. fntType=0, fntSize is one of the TYPE_FontSize constants from FONT.H */
#define	TAP_Win_SetFont	TAP_API(0x1f8, void, (TYPE_Window *win, byte fntType, byte fntSize))

/* Add a string to the listbox */
#define	TAP_Win_AddItem	TAP_API(0x1fc, void, (TYPE_Window *win, char *))

/* Get currently selected string */
#define	TAP_Win_GetSelection  TAP_API(0x200, dword, (TYPE_Window *win))

/* Set currently selected string */
#define	TAP_Win_SetSelection  TAP_API(0x204, void, (TYPE_Window *win, dword pos))

/* Handle key for listbox navigation */
#define	TAP_Win_Action	TAP_API(0x208, void, (TYPE_Window *win, dword key))

/* **************************************************************************** */
/* These may be the game functions */
/* **************************************************************************** */

#define	Api_220	TAP_API(0x220, int, ())
#define	Api_224	TAP_API(0x224, int, ())
#define	Api_228	TAP_API(0x228, int, ())
#define	Api_22c	TAP_API(0x22c, int, ())
#define	Api_230	TAP_API(0x230, int, ())
#define	Api_234	TAP_API(0x234, int, ())
#define	Api_238	TAP_API(0x238, int, ())
#define	Api_23c	TAP_API(0x23c, int, ())
#define	Api_240	TAP_API(0x240, int, ())

/* **************************************************************************** */
/* Service management API */
/* **************************************************************************** */

/* Get total number of TV and Radio channels */
#define	TAP_Channel_GetTotalNum	   TAP_API(0x26c, int, (int *nTvSvc, int *nRadioSvc))

/* Get info about first channel */
#define TAP_Channel_GetFirstInfo   TAP_API(0x270, int, (int svcType, TYPE_TapChInfo *chInfo ))

/* Get info about next channel */
#define TAP_Channel_GetNextInfo    TAP_API(0x274, int, ( TYPE_TapChInfo *chInfo ))

/* Get info about specified channel. svcType is one of the TYPE_ServiceType constants
   Notes: TYPE_TapChInfo slightly different than on TF5000, see above */
#define	TAP_Channel_GetInfo	TAP_API(0x278, int, (int svcType, int svcNum, TYPE_TapChInfo*))

// Notes: svcType= 0=TV, 1=Radio  svcNum is Zero-Based, so 1 less than shown on screen
#define	TAP_Channel_GetCurrent	TAP_API(0x27c, int, (int *svcType, int *svcNum))

// Notes: svcType= 0=TV, 1=Radio  svcNum is Zero-Based, so 1 less than shown on screen
#define	TAP_Channel_Start	TAP_API(0x280, int, (int svcType, int chNum))

/* **************************************************************************** */
/* EPG info */
/* **************************************************************************** */

/* From the Topfield 5000 API: fully tested! */

// Notes: event_data_t as described above
#define	TAP_GetEvent	TAP_API(0x2a8, event_data_t*, (int svcType, int svcNum, int *eventNum))

// Notes: event_data_t as described above
#define	TAP_GetCurrentEvent	TAP_API(0x2ac, event_data_t*, (int svcType, int svcNum))

/* **************************************************************************** */
/* Convenience functions for standard C                                         */
/* **************************************************************************** */

#define printf TAP_Print
#define	malloc TAP_MemAlloc
#define	free TAP_MemFree
#define	sprintf TAP_SPrint

/* **************************************************************************** */
/* Comatibility functions with the old Topfield API from PeN                    */
/* **************************************************************************** */

#ifdef compatibility_functions

#define ExecTAPCallbacks TAP_SystemProc
#define TAPSetTSRCallback TAP_SetTSRCallback
#define TAPClearCallback TAP_ClearCallback
#define TAPTerminate TAP_Exit
#define ConsoleCheckChar TAP_KbHit
#define ConsoleReadChar TAP_GetCh
#define ConsolePrintChar TAP_PutCh
#define WindowCreate TAP_Osd_Create
#define	WindowClear	TAP_Osd_Delete
#define Api_e4 TAP_Osd_Move
#define	WindowFillRegion TAP_Osd_FillBox
#define	WindowPaintPixmap TAP_Osd_PutBox
#define	WindowGetPixmap TAP_Osd_GetBox
#define	WindowSetPalette TAP_Osd_SetLut
#define	WindowActivate TAP_Osd_Ctrl
#define	Api_fc TAP_Osd_SetTransparency
#define	WindowDrawRectangle TAP_Osd_Draw3dBox
#define	WindowDrawBox TAP_Osd_Draw3dBoxFill
#define	WindowCopyRegion TAP_Osd_Copy
#define	Api_12c TAP_Osd_SaveBox
#define	WindowPaintRLEBitmapNoResize TAP_Osd_RestoreBox
#define	WindowGetPixel TAP_Osd_GetPixel
#define	WindowDrawPixel TAP_Osd_PutPixel
#define WindowGetDefaultPalette TAP_GetDefaultPalette
#define	FileOpen	  TAP_API(0x168, int, (char *name))
#define	FileRead	   TAP_API(0x16c, int, (void *buffer, int size, int count, int handle))
#define	FileWrite	   TAP_API(0x170, int, (void *buffer, int size, int count, int handle))
#define	FileClose	   TAP_API(0x174, void, (int handle))
#define	FileOpenDir	      TAP_API(0x178, int, (directory_entry_t *))
#define	FileReadDir	     TAP_API(0x17c, int, (directory_entry_t *))
#define	FileSeek	  TAP_API(0x180, int, (int handle, int offset, int whence))
#define	FileGetSizeOfFile  TAP_API(0x184, int, (int handle))
#define	FileGetPosition	TAP_API(0x188, int, (int handle))
#define	FileGetTotalDiskBlocks	TAP_API(0x18c, int, (void))
#define	FileGetOccupiedDiskBlocks	TAP_API(0x190, int, (void))
#define	FileDelete	   TAP_API(0x194, int, (char *name))
#define	FileCheckFileExists	TAP_API(0x198, int, (char *name))
#define	FileCreate	   TAP_API(0x19c, int, (char *name, int type))
#define	FileChdir	      TAP_API(0x1a0, int, (char *name))
#define	TextPaintTextInFont TAP_Osd_PutS
#define	TextDisplayWidth TAP_Osd_GetW
#define	TextShow TAP_Osd_PutString
#define	Api_84_put_to_queue_7_cmd_3	TAP_API(0x84, int, (char par))
#define	CalendarGetDateTime TAP_GetTime
#define	HeapGetState TAP_MemInfo
#define	GetTicks TAP_GetTick
#define	DelayTicks TAP_Delay
#define	ConvertFromMJDDate TAP_ExtractMjd
#define	ConvertToMJDDate TAP_MakeMjd
#define	x_times_sin_alpha TAP_Sin
#define	x_times_cos_alpha TAP_Cos
#define	ChoiceCreateHeader	TAP_API(0x1e0, int, (menu_t *, char *name, int fntType, int fntSize))
#define	Api_1e4	TAP_API(0x1e4, int, ())
#define	ChoiceGetData	        TAP_API(0x1e8, int, (menu_t *))
#define	ChoiceDraw          	TAP_API(0x1ec, int, (menu_t *))
#define	ChoiceCreate	TAP_API(0x1f0, int, (menu_t *, int window, int x, int y, int w, int h, int save, int bScr))
#define	ChoiceDestroy	TAP_API(0x1f4, int, (menu_t *))
#define	ChoiceSetFont	TAP_API(0x1f8, int, (menu_t *, char f_script, char f_size))
#define	ChoiceAddLine	TAP_API(0x1fc, int, (menu_t *, char *))
#define	ChoiceGetChoice	      TAP_API(0x200, int, (menu_t *))
#define	ChoiceSetChoice	      TAP_API(0x204, int, (menu_t *, int pos))
#define	ChoiceNavigate	TAP_API(0x208, int, (menu_t *, int remotecode))
#define GetNumberOfTVRadioServices TAP_Channel_GetTotalNum
#define	StartServiceEnum           TAP_API(0x270, int, (int svcType, service_info_t*))
#define	ServiceInfo TAP_Channel_GetInfo
#define	GetCurrentServiceNumber TAP_Channel_GetCurrent
#define	TuneService TAP_Channel_Start

#endif


/* The API table at the start of each TAP application */
extern const api_table __entrytable[];
/* non-const version of the same for setting callbacks */
extern api_table __entrytable__[];

/* This is used in TF original TAP applications to setup pointers to API
   ruotines, with this kit it can be empty. Should return 0. In
   January 2002 firmware, this function can be more complicated.
   It should also test for compatibility, ie. minumum API level etc.
*/
int initialize(void);

/* This is the main routine you have to write. There are no arguments.
   returning 0 means that the application has finished, returning non-0
   means that this is a TSR and that the system should keep it in memory
   and periodically call the TAP callback function.
   You must terminate a TSR TAP with TAPTerminate().
*/

int TAP_main(void);


