int tf_fixup_reloc(void)
{
  	int(*fpptr)()=initialize;
	int offset = (fpptr - _initialize_ptr) >> 2;
	
	
	int ***fixupstart, fixuplength;
	int ***bssstart, bsslength;

	int i;

	int **fixptr;

	fixupstart =  *(int****)(0x400 + (offset<<2)) + offset;
	fixuplength = (*(int****)(0x404 + (offset<<2)) + offset) - fixupstart;
	bssstart =  *(int****)(0x408 + (offset<<2)) + offset;
	bsslength = ((*(int****)(0x40c + (offset<<2)) + offset) - bssstart) * 4;
	
	bzero(bssstart, bsslength);

	printf("BSS: %x, length: %x, initialize=%x\n", bssstart, bsslength, initialize);


	for (i = 0; i < fixuplength; i++)
	{
	  
	  fixptr = fixupstart[i] + offset;

	  *fixptr += offset;
	}

	if(fpptr != _initialize_ptr)
 	{
	    printf("ASSERT: Relocation fixup failed");
	    return 1;
	}
	return 0;
}

