/***************************************************************************************
    Console driver program for Topfield TF4000PVR disk processing

    Copyright (c) 2002 Petr Novak <topfield@centrum.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "topfield.h"
#include <string.h>

int repack;

void pr_dir(int entries);

void showpercent(int percent)
{
	if (percent < 0) {
		fprintf(stderr, "INFO: %s", tf_error);
	} else {
		fprintf(stderr, "%3d%% completed...\r", percent);
	}
}

int main(int argc, char *argv[])
{
	BYTE buffer[512];
	long file;
	DWORD which;
	int entries;

	if (argc < 2 || argc > 3 || !(
		!stricmp(argv[1], "disk") ||
		!stricmp(argv[1], "raw") ||
		!stricmp(argv[1], "MP3") ||
		!stricmp(argv[1], "M2V") ||
		!stricmp(argv[1], "M2P") ||
		!stricmp(argv[1], "VOB") ||
		!stricmp(argv[1], "TS") ) ) {
		fprintf(stderr, "%s: Usage: %s (disk|raw|MP3|M2V|M2P|VOB|TS) [repack_size]\n", argv[0], argv[0]);
		exit(1);
	}

	repack = 0;
	if (argc == 3) repack = atoi(argv[2]);

	if (open_tfdisk(showpercent) == 0) {
		if (!stricmp(argv[1], "disk")) {
			fprintf(stderr, "Copying whole Topfield disk to PC file\n");
			if (copy_disk())
				fprintf(stderr, "ERROR: %s", tf_error);
			return 0;
		}
		entries = parse_dir(0, (((tf->cluster_size - ntohl(tf->superblock.empty_in_root)) & 0xffe00) + 512)/sizeof(directory_entry_t), 0xff, 0xd1);
		if (entries <= 0)
			fprintf(stderr, "ERROR: %s", tf_error);
		else do {
			pr_dir(entries);
			printf("---> "); fgets(buffer, sizeof(buffer), stdin);
			file = strtol(buffer, NULL, 0);
			if (file > 0) {
				which = file-1;
				fprintf(stderr, "\nRecording '%s' size %I64d MB %s copy\n\n", tf->dir[which].name, (long long)(tf->dir[which].count_of_blocks)*tf->cluster_size / (1024*1024), argv[1]);
				if (!stricmp(argv[1], "raw")) {
					if (dump_file(which))
						fprintf(stderr, "ERROR: %s", tf_error);
				}
				if (!stricmp(argv[1], "MP3")) {
					if (convert_mp3(which, showpercent))
						fprintf(stderr, "ERROR: %s", tf_error);
				}
				if (!stricmp(argv[1], "M2V")) {
					if (convert_m2v(which, showpercent))
						fprintf(stderr, "ERROR: %s", tf_error);
				}
				if (!stricmp(argv[1], "M2P")) {
					if (convert_m2p(which, showpercent))
						fprintf(stderr, "ERROR: %s", tf_error);
				}
				if (!stricmp(argv[1], "VOB")) {
					if (convert_vob(which, showpercent))
						fprintf(stderr, "ERROR: %s", tf_error);
				}
				if (!stricmp(argv[1], "TS")) {
					if (convert_ts(which, showpercent))
						fprintf(stderr, "ERROR: %s", tf_error);
				}
			}
		} while (file > 0);
	} else
		fprintf(stderr, "ERROR: %s", tf_error);
}

void pr_dir(int entries)
{
	int i;

	int year, month, day, hour, minute;
	char date[20];

	fprintf(stderr, "\n\n");
	for (i = 0; i < entries; i++) {
		convert_date_time(tf->dir[i].data,
			&year, &month, &day, &hour, &minute);
		if (year)
			sprintf(date, "%02d-%02d-%04d %02d:%02d", day, month, year, hour, minute);
		else
			strcpy(date, "                ");
		fprintf(stderr, "%3d: %s %5I64d MB '%s'\n", i+1, date, (long long)(tf->dir[i].count_of_blocks) * tf->cluster_size / (1024*1024), tf->dir[i].name);
	}
}
