
#include "tap.h"

#define ID_QUICKEPG 0x80000102

TAP_ID( ID_QUICKEPG );
TAP_PROGRAM_NAME("Quick EPG");
TAP_AUTHOR_NAME("TOPFIELD");
TAP_DESCRIPTION("It is sample tap program for show how to handle epg data");
TAP_ETCINFO(__DATE__);

static int _exitFlag = 0;
static int _epgShow = 0;
static word rgn;

void DrawLine( word rgn, int Ax, int Ay, int Bx, int By, int Color );

int _curIdx, _topIdx, _bottomIdx;
int _height;
TYPE_TapEvent *_evtInfo;
int _svcType, _svcNum, _eventNum;
int _maxSvcNum;

char _strBuf[32];

#define X	100
#define Y	 80
#define W	520
#define H	500

#define MAX_LIST	10

void GetEvent(	int svcType, int svcNum )
{
	int i;

	if( _evtInfo )
	{
		TAP_MemFree( _evtInfo );
		_evtInfo = 0;
	}

	_evtInfo = TAP_GetEvent( svcType, svcNum, &_eventNum );

	_curIdx = 0;
	for( i=0; i<_eventNum; i++ )
	{
		if( _evtInfo[i].runningStatus == 4 )
		{
			_curIdx = i;
			break;
		}
	}

	if( _eventNum < MAX_LIST )
		_topIdx = 0;
	else
		_topIdx = _curIdx;
	_bottomIdx = _topIdx + (MAX_LIST-1);
	if( _bottomIdx >= _eventNum )
		_bottomIdx = _eventNum - 1;

}

void DrawItem( int idx )
{
	int y;
	dword fc, bc;

	y = 30 + (idx-_topIdx)*29;

	if( idx==_curIdx )
	{
		y+=3;
		fc = COLOR_Black;
		bc = COLOR_User11;
	}
	else
	{
		y+=3;
		fc = COLOR_Black;
		bc = COLOR_User8;
	}
	TAP_SPrint( _strBuf, " %02d:%02d ~ %02d:%02d",
		(_evtInfo[idx].startTime>>8)&0xff,_evtInfo[idx].startTime&0xff,
		(_evtInfo[idx].endTime>>8)&0xff,_evtInfo[idx].endTime&0xff );
	TAP_Osd_PutString1622( rgn, X+2, Y+y+2, X+120, _strBuf, fc, bc );
	TAP_Osd_PutString1622( rgn, X+120+4, Y+y+2, X+W-4, "   ", fc, bc );
	TAP_Osd_PutString1622( rgn, X+120+10, Y+y+2, X+W-4, _evtInfo[idx].eventName, fc, bc );
	y+=26;

}

void DrawEvent( void )
{
	int i;
	for( i=_topIdx; i<=_bottomIdx; i++ )
	{
		DrawItem( i );
	}
}

void DrawEPG( void )
{
	int i, y;
	TYPE_TapChInfo chInfo;

	GetEvent( _svcType, _svcNum );

	TAP_Osd_FillBox( rgn, X, Y, W, 35, COLOR_User13 );

	y = 30;
	for( i=0; i<10; i++ )
	{
		TAP_Osd_FillBox( rgn, X, Y+y, W, 3, COLOR_User11 );
		TAP_Osd_FillBox( rgn, X, Y+y+1, W, 1, COLOR_User12 );
		y+=3;
		TAP_Osd_FillBox( rgn, X, Y+y, W, 26, COLOR_User8 );
		y+=26;
	}
	TAP_Osd_FillBox( rgn, X+120, Y+30, 2, y-30, COLOR_User12 );

	TAP_Osd_DrawRectangle( rgn, X, Y, W, y, 1, COLOR_User12 );
	TAP_Osd_DrawRectangle( rgn, X-1, Y-1, W+2, y+2, 1, COLOR_User10 );
	TAP_Osd_FillBox( rgn, X+W+1, Y+10, 10, y, COLOR_User1 );
	TAP_Osd_FillBox( rgn, X+10, Y+y+1, W, 10, COLOR_User1 );

	TAP_Osd_PutStringAf1926( rgn, X+5, Y+4, -1, "Quick EPG", COLOR_DarkBlue, COLOR_None );

	TAP_Channel_GetInfo( _svcType, _svcNum, &chInfo );
	TAP_Osd_PutStringAf1926( rgn, X+125, Y+4, X+W-4, chInfo.chName, COLOR_DarkCyan, COLOR_None );

	DrawEvent();
}

dword TAP_EventHandler( word event, dword param1, dword param2 )
{
	int r, t;
	dword mainState, subState;

    if( event != EVT_KEY )
        return param1;
    
	TAP_GetState( &mainState, &subState );
    
    if( mainState != STATE_Normal )
    {
        return param1;
    }

    if( _epgShow==0 )
    {
		if( param1 == RKEY_Guide )
		{
			_epgShow = 1;
			TAP_ExitNormal();
			rgn = TAP_Osd_Create( 0, 0, 720, 576, 0, FALSE );
			TAP_Channel_GetCurrent( &_svcType, &_svcNum );
			TAP_Channel_GetTotalNum( &t, &r );
			if( _svcType == SVC_TYPE_Tv )
				_maxSvcNum = t;
			else
				_maxSvcNum = r;
			DrawEPG();
			return 0;
		}
        ef( param1 == RKEY_0 )
    	{
    		TAP_MemFree( _evtInfo );
    		TAP_Exit();
    		return 0;
    	}
		return param1;
    }
        
	switch( param1 )
	{
		case RKEY_Ok	:
		case RKEY_Guide :
		case RKEY_Exit	:
			if( _epgShow )
			{
				_epgShow = 0;
				TAP_Osd_Delete(rgn);
				TAP_EnterNormal();
			}
            break;

		case RKEY_VolUp :
			_svcNum = (_svcNum+1) % _maxSvcNum;
			DrawEPG();
			//TAP_Channel_Start( _svcType, _svcNum );
			break;

		case RKEY_VolDown :
			_svcNum = (_svcNum+_maxSvcNum-1) % _maxSvcNum;
			DrawEPG();
			//TAP_Channel_Start( _svcType, _svcNum );
			break;

		case RKEY_ChUp :
			_topIdx--;
			if( _topIdx<0 )
				_topIdx = 0;
			else
			{
				_bottomIdx = _topIdx + (MAX_LIST-1);
				if( _bottomIdx >= _eventNum )
					_bottomIdx = _eventNum - 1;
				TAP_Osd_Copy( rgn, rgn, X, Y+30, W, 29*9, X, Y+30+29, FALSE );
				DrawItem( _topIdx );
			}
			break;

		case RKEY_ChDown :
			_bottomIdx++;
			if( _bottomIdx >= _eventNum )
				_bottomIdx = _eventNum - 1;
			else
			{
				_topIdx++;
				TAP_Osd_Copy( rgn,rgn, X, Y+30+29, W, 29*9, X, Y+30, FALSE );
				DrawItem( _bottomIdx );
			}
			break;
            
	}

	return 0;
}

int TAP_Main(void)
{
	int i;
    
	return 1;
}

