#include "tap.h"

unsigned char fireLut[256][4]={
	  0,  0,  0, 1,
	  0,  0, 24, 0,
	  0,  0, 24, 0,
	  0,  0, 28, 0,

	  0,  0, 32, 0,
	  0,  0, 32, 0,
	  0,  0, 36, 0,
	  0,  0, 40, 0,

	  8,  0, 40, 0,
	 16,  0, 36, 0,
	 24,  0, 36, 0,
	 32,  0, 32, 0,

	 40,  0, 28, 0,
	 48,  0, 28, 0,
	 56,  0, 24, 0,
	 64,  0, 20, 0,

	 72,  0, 20, 0,
	 80,  0, 16, 0,
	 88,  0, 16, 0,
	 96,  0, 12, 0,

	104,  0,  8, 0,
	112,  0,  8, 0,
	120,  0,  4, 0,
	128,  0,  0, 0,

	128,  0,  0, 0,
	132,  0,  0, 0,
	136,  0,  0, 0,
	140,  0,  0, 0,

	144,  0,  0, 0,
	144,  0,  0, 0,
	148,  0,  0, 0,
	152,  0,  0, 0,

	156,  0,  0, 0,
	160,  0,  0, 0,
	160,  0,  0, 0,
	164,  0,  0, 0,

	168,  0,  0, 0,
	172,  0,  0, 0,
	176,  0,  0, 0,
	180,  0,  0, 0,

	184,  4,  0, 0,
	188,  4,  0, 0,
	192,  8,  0, 0,
	196,  8,  0, 0,

	200, 12,  0, 0,
	204, 12,  0, 0,
	208, 16,  0, 0,
	212, 16,  0, 0,

	216, 20,  0, 0,
	220, 20,  0, 0,
	224, 24,  0, 0,
	228, 24,  0, 0,

	232, 28,  0, 0,
	236, 28,  0, 0,
	240, 32,  0, 0,
	244, 32,  0, 0,

	252, 36,  0, 0,
	252, 36,  0, 0,
	252, 40,  0, 0,
	252, 40,  0, 0,

	252, 44,  0, 0,
	252, 44,  0, 0,
	252, 48,  0, 0,
	252, 48,  0, 0,

	252, 52,  0, 0,
	252, 52,  0, 0,
	252, 56,  0, 0,
	252, 56,  0, 0,

	252, 60,  0, 0,
	252, 60,  0, 0,
	252, 64,  0, 0,
	252, 64,  0, 0,

	252, 68,  0, 0,
	252, 68,  0, 0,
	252, 72,  0, 0,
	252, 72,  0, 0,

	252, 76,  0, 0,
	252, 76,  0, 0,
	252, 80,  0, 0,
	252, 80,  0, 0,

	252, 84,  0, 0,
	252, 84,  0, 0,
	252, 88,  0, 0,
	252, 88,  0, 0,

	252, 92,  0, 0,
	252, 96,  0, 0,
	252, 96,  0, 0,
	252,100,  0, 0,

	252,100,  0, 0,
	252,104,  0, 0,
	252,104,  0, 0,
	252,108,  0, 0,

	252,108,  0, 0,
	252,112,  0, 0,
	252,112,  0, 0,
	252,116,  0, 0,

	252,116,  0, 0,
	252,120,  0, 0,
	252,120,  0, 0,
	252,124,  0, 0,

	252,124,  0, 0,
	252,128,  0, 0,
	252,128,  0, 0,
	252,132,  0, 0,

	252,132,  0, 0,
	252,136,  0, 0,
	252, 136,	0, 0,
	252, 140,	0, 0,

	252, 140,	0, 0,
	252, 144,	0, 0,
	252, 144,	0, 0,
	252, 148,	0, 0,

	252, 152,	0, 0,
	252, 152,	0, 0,
	252, 156,	0, 0,
	252, 156,	0, 0,

	252, 160,	0, 0,
	252, 160,	0, 0,
	252, 164,	0, 0,
	252, 164,	0, 0,

	252, 168,	0, 0,
	252, 168,	0, 0,
	252, 172,	0, 0,
	252, 172,	0, 0,

	252, 176,	0, 0,
	252, 176,	0, 0,
	252, 180,	0, 0,
	252, 180,	0, 0,

	252, 184,	0, 0,
	252, 184,	0, 0,
	252, 188,	0, 0,
	252, 188,	0, 0,

	252, 192,	0, 0,
	252, 192,	0, 0,
	252, 196,	0, 0,
	252, 196,	0, 0,

	252, 200,	0, 0,
	252, 200,	0, 0,
	252, 204,	0, 0,
	252, 208,	0, 0,

	252, 208,	0, 0,
	252, 208,	0, 0,
	252, 208,	0, 0,
	252, 208,	0, 0,

	252, 212,	0, 0,
	252, 212,	0, 0,
	252, 212,	0, 0,
	252, 212,	0, 0,

	252, 216,	0, 0,
	252, 216,	0, 0,
	252, 216,	0, 0,
	252, 216,	0, 0,

	252, 216,	0, 0,
	252, 220,	0, 0,
	252, 220,	0, 0,
	252, 220,	0, 0,

	252, 220,	0, 0,
	252, 224,	0, 0,
	252, 224,	0, 0,
	252, 224,	0, 0,

	252, 224,	0, 0,
	252, 228,	0, 0,
	252, 228,	0, 0,
	252, 228,	0, 0,

	252, 228,	0, 0,
	252, 228,	0, 0,
	252, 232,	0, 0,
	252, 232,	0, 0,

	252, 232,	0, 0,
	252, 232,	0, 0,
	252, 236,	0, 0,
	252, 236,	0, 0,

	252, 236,	0, 0,
	252, 236,	0, 0,
	252, 240,	0, 0,
	252, 240,	0, 0,

	252, 240,	0, 0,
	252, 240,	0, 0,
	252, 240,	0, 0,
	252, 244,	0, 0,

	252, 244,	0, 0,
	252, 244,	0, 0,
	252, 244,	0, 0,
	252, 248,	0, 0,

	252, 248,	0, 0,
	252, 248,	0, 0,
	252, 248,	0, 0,
	252, 252,	0, 0,

	252, 252,	4, 0,
	252, 252,	8, 0,
	252, 252,  12, 0,
	252, 252,  16, 0,

	252, 252,  20, 0,
	252, 252,  24, 0,
	252, 252,  28, 0,
	252, 252,  32, 0,

	252, 252,  36, 0,
	252, 252,  40, 0,
	252, 252,  40, 0,
	252, 252,  44, 0,

	252, 252,  48, 0,
	252, 252,  52, 0,
	252, 252,  56, 0,
	252, 252,  60, 0,

	252, 252,  64, 0,
	252, 252,  68, 0,
	252, 252,  72, 0,
	252, 252,  76, 0,

	252, 252,  80, 0,
	252, 252,  84, 0,
	252, 252,  84, 0,
	252, 252,  88, 0,

	252, 252,  92, 0,
	252, 252,  96, 0,
	252, 252, 100, 0,
	252, 252, 104, 0,

	252, 252, 108, 0,
	252, 252, 112, 0,
	252, 252, 116, 0,
	252, 252, 120, 0,

	252, 252, 124, 0,
	252, 252, 124, 0,
	252, 252, 128, 0,
	252, 252, 132, 0,

	252, 252, 136, 0,
	252, 252, 140, 0,
	252, 252, 144, 0,
	252, 252, 148, 0,

	252, 252, 152, 0,
	252, 252, 156, 0,
	252, 252, 160, 0,
	252, 252, 164, 0,

	252, 252, 168, 0,
	252, 252, 168, 0,
	252, 252, 172, 0,
	252, 252, 176, 0,

	252, 252, 180, 0,
	252, 252, 184, 0,
	252, 252, 188, 0,
	252, 252, 192, 0,

	252, 252, 196, 0,
	252, 252, 200, 0,
	252, 252, 204, 0,
	252, 252, 208, 0,

	252, 252, 208, 0,
	252, 252, 212, 0,
	252, 252, 216, 0,
	252, 252, 220, 0,

	252, 252, 224, 0,
	252, 252, 228, 0,
	252, 252, 232, 0,
	252, 252, 236, 0,

	252, 252, 240, 0,
	252, 252, 244, 0,
	252, 252, 248, 0,
	252, 252, 252, 0,
};

#define ABS(i)	(((i)<0)?-(i):(i))
#define FIRE_DEC  5

void Fire( byte *buffer, int xs, int ys )
{
	int i, j, c;
	int r1, r2, dec;

	ys--;

	for( i=1; i<ys-10; i++ )
	{
		r1 = rand(3);
		r2 = rand(3);
		dec = 3 + rand(5);
		for( j=1; j<xs-1; j++ )
		{
			 c = (
				 buffer[ i*xs + j	] +
				 buffer[ i*xs + j-r1 ] +
				 buffer[ i*xs + j+r2 ] +
				 buffer[ (i+1)*xs+j ]
			 )/4;
			 if( c > 150 ) c = 150;
			 if(c>=dec)
				buffer[ (i-1)*xs+j ]=c-dec;
			 else
				buffer[ (i-1)*xs+j ]=0;
		}
	}
/*
	for( i=ys-13; i<ys; i++ )
	{
		for( j=1; j<xs-1; j++ )
		{
			 c = (
				 buffer[ i*xs + j	] +
				 buffer[ i*xs + j-1 ] +
				 buffer[ i*xs + j+1 ] +
				 buffer[ (i+1)*xs+j ]
			 )/4;
			 buffer[ (i-1)*xs+j ]=c+FIRE_DEC;
		}
	}
*/

}

#define FIRE2_DEC 2

void Fire2( byte *buffer, int xs, int ys )
{
	int i, j, c;

	ys--;

	for( i=1; i<ys; i++ )
	{
		for( j=1; j<xs-1; j++ )
		{
			 c = (
				 buffer[ i*xs + j	] +
				 buffer[ i*xs + j-1 ] +
				 buffer[ i*xs + j+1 ] +
				 buffer[ (i+1)*xs+j ]
			 )/4;
			 if(c>=FIRE2_DEC) buffer[ (i-1)*xs+j ]=c-FIRE2_DEC;
		}
	}
}

/*
	int Fire2Power=127;

	for( c=50; c<130; c++ )
	{
		buffer[ (ys-1)*xs+ c*xs/180 ]=Sin(c)/4+rand()%128;
	}

	for( c=50; c<130; c++ )
	{
		buffer[ (ys-1)*xs+ c*xs/180 ]=Sin(c)*Fire2Power/127+rand()%127;
	}

*/
