#include "tap.h"
#include "gif_lib.h"

/* Make some variables global, so we could access them faster: */
static int
	ImageNum = 0,
	BackGround = 0,
	AlphaFlag = FALSE,
	HelpFlag = FALSE,
	ColorMapSize = 0,
	InterlacedOffset[] = { 0, 4, 2, 1 }, /* The way Interlaced image should. */
	InterlacedJumps[] = { 8, 8, 4, 2 };    /* be read - offsets and jumps... */
static GifColorType
	*ColorMap;

extern int _GifError;

int LoadGifDirect( int rgn, char *name )
{
	int i, j, Error, NumFiles, Size, Row, Col, Width, Height, ExtCode, Count;
	GifRecordType RecordType;
	GifByteType *Extension;
	char **FileName = NULL;
	byte *ScreenBuffer;
	GifFileType *GifFile;
	dword	width, height;
	static byte lut[256][4];
    dword x, y;

	GifFile = DGifOpen( name );
	if( GifFile == NULL )
	{
		TAP_Print(" error code = %d (%x)\r\n",    _GifError, _GifError );
		return 0;
	}

	Size = GifFile -> SWidth;

	ScreenBuffer = (byte *)TAP_MemAlloc(Size);

	if( GifFile->SWidth < 720 && GifFile->SHeight < 576 )
	{
		width = GifFile->SWidth;
		height = GifFile->SHeight;
	}
	else if( GifFile->SWidth < 720 )
	{
		width = GifFile->SWidth;
		height = 576;
	}
	else if( GifFile->SHeight < 576 )
	{
		width = 720;
		height = GifFile->SHeight;
	}
	else
	{
		width = 720;
		height = 576;
	}

	x = (720-width)/2;
    y = (576-height)/2;

//	  TAP_Print("width = %d(%d), height = %d(%d)\r\n", GifFile->SWidth, width, GifFile->SHeight, height);

	BackGround = GifFile -> SBackGroundColor;
	ColorMap = (GifFile -> IColorMap ? GifFile -> IColorMap :
					   GifFile -> SColorMap);
	ColorMapSize = 1 << (GifFile -> IColorMap ? GifFile -> IBitsPerPixel :
								GifFile -> SBitsPerPixel);

	for( i=0; i<256; i++ )
	{
		lut[i][0] = ColorMap[i].Red;
		lut[i][1] = ColorMap[i].Green;
		lut[i][2] = ColorMap[i].Blue;
		lut[i][3] = 0;
	}

	TAP_Osd_SetLut( 0, lut );

//	  for( i = 0; i < GifFile -> SWidth; i++)  /* Set its color to BackGround. */
//	  ScreenBuffer[0][i] = GifFile -> SBackGroundColor;

	/* Scan the content of the GIF file and load the image(s) in: */
	do
	{
		if( DGifGetRecordType(GifFile, &RecordType) == GIF_ERROR )
		{
			TAP_MemFree( ScreenBuffer );
			DGifCloseFile(GifFile);
			return 0;
		}

		switch (RecordType)
		{
			case IMAGE_DESC_RECORD_TYPE:
				if (DGifGetImageDesc(GifFile) == GIF_ERROR)
				{
					TAP_MemFree( ScreenBuffer );
					DGifCloseFile(GifFile);
					return 0;
				}
				Row = GifFile -> ITop; /* Image Position relative to Screen. */
				Col = GifFile -> ILeft;
				Width = GifFile -> IWidth;
				Height = GifFile -> IHeight;
				//TAP_Print("\n: Image %d at (%d, %d) [%dx%d]:     ", ++ImageNum, Col, Row, Width, Height);
				if (GifFile -> ILeft + GifFile -> IWidth > GifFile -> SWidth ||
				   GifFile -> ITop + GifFile -> IHeight > GifFile -> SHeight)
				 {
					//TAP_Print( "Image %d is not confined to screen dimension, aborted.\n");
					TAP_MemFree( ScreenBuffer );
					DGifCloseFile(GifFile);
					return 0;
				}
				if (GifFile -> IInterlace)
				{
					/* Need to perform 4 passes on the images: */
					for (Count = i = 0; i < 4; i++)
					{
						for (j = Row + InterlacedOffset[i]; j < Row + Height; j += InterlacedJumps[i])
						{
							if (DGifGetLine(GifFile, &ScreenBuffer[Col],	Width) == GIF_ERROR)
							{
								TAP_MemFree( ScreenBuffer );
								DGifCloseFile(GifFile);
								return 0;
							}
							TAP_Osd_DrawPixmap( rgn, x, y+j, width, 1, ScreenBuffer, FALSE, OSD_256 );
						}
					}
				}
				else
				{
					for (i = 0; i < Height; i++)
					{
						if (DGifGetLine(GifFile, &ScreenBuffer[Col],	Width) == GIF_ERROR)
						{
							TAP_MemFree( ScreenBuffer );
							DGifCloseFile(GifFile);
							return 0;
						}
						TAP_Osd_DrawPixmap( rgn, x, y+Row, width, 1, ScreenBuffer, FALSE, OSD_256 );
						Row++;
					}
				}
				break;
			case EXTENSION_RECORD_TYPE:
				/* Skip any extension blocks in file: */
				if (DGifGetExtension(GifFile, &ExtCode, &Extension) == GIF_ERROR)
				{
					TAP_MemFree( ScreenBuffer );
					DGifCloseFile(GifFile);
					return 0;
				}
				while (Extension != NULL)
				{
					if (DGifGetExtensionNext(GifFile, &Extension) == GIF_ERROR)
					{
						TAP_MemFree( ScreenBuffer );
						DGifCloseFile(GifFile);
						return 0;
					}
				}
				break;
			case TERMINATE_RECORD_TYPE:
				break;
			default:			/* Should be traps by DGifGetRecordType. */
				break;
		}

	}
	while (RecordType != TERMINATE_RECORD_TYPE);

	TAP_MemFree( ScreenBuffer );

	DGifCloseFile(GifFile);

	return 1;
}

