#include "tap.h"

#define ID_TIMERLIST 0x80000106

TAP_ID( ID_TIMERLIST );
TAP_PROGRAM_NAME("TIMERLIST");
TAP_AUTHOR_NAME("TOPFIELD");
TAP_DESCRIPTION("TIMER LIST");
TAP_ETCINFO(__DATE__);


bool _exitFlag = FALSE;

dword TAP_EventHandler( word event, dword param1, dword param2 )
{
    if( event == EVT_KEY )
    {
        _exitFlag = TRUE;
	    return 0;
    }
    return param1;
}

TYPE_TimerInfo timerInfo;
	
int TAP_Main(void)
{
	int result;
	int i;
	int totalTimerNum;
	word	year;
	byte	month, day, weekDay;
	
	totalTimerNum = TAP_Timer_GetTotalNum();

	TAP_Print("total Timer = %d\r\n", totalTimerNum );

	// list 
	for( i=0; i<totalTimerNum; i++ )
	{
		TAP_Print("-----------------------------------------------------\r\n");
		TAP_Timer_GetInfo( i, &timerInfo );
		TAP_Print("isRec = %d\r\n", timerInfo.isRec );
		TAP_Print("tuner = %d\r\n", timerInfo.tuner );
		TAP_Print("svcType = %d\r\n", timerInfo.svcType );
		TAP_Print("svcNum = %d\r\n", timerInfo.svcNum );
		TAP_Print("reservationType = %d\r\n", timerInfo.reservationType );
		TAP_Print("nameFix = %d\r\n", timerInfo.nameFix );
		TAP_Print("duration = %d\r\n", timerInfo.duration );

		TAP_ExtractMjd( timerInfo.startTime>>16, &year, &month, &day, &weekDay) ;
		TAP_Print("startTime = %d/%d/%d %02d:%02d\r\n", day, month, year, (timerInfo.startTime&0xff00)>>8, (timerInfo.startTime&0xff) );
		TAP_Print("fileName = %s\r\n", timerInfo.fileName );
	}
	TAP_Print("-----------------------------------------------------\r\n");

	// modify last entry's file name
	if( totalTimerNum )
	{
		TAP_Timer_GetInfo( totalTimerNum-1, &timerInfo );
		TAP_SPrint( timerInfo.fileName, "FILE NAME MODIFY Entry %d.rec", totalTimerNum );
		result = TAP_Timer_Modify( totalTimerNum-1, &timerInfo );
		
		if( result == 0xffffffff )	// invalid entryNum
		{
			TAP_Print("Invalid entry num\r\n");
		}
		ef( result == 0xfffffffe )	// invalid tuner
		{
			TAP_Print("Invalid Tuner\r\n");
		}
		ef( result >= 0xffff0000 )	// duplicated with entry N
		{
			TAP_Print("Duplicated with entry %d\r\n", result & 0x00000fff );
		}
			
		TAP_Print("Modify result = %x\r\n", result );
	}

	// delete first entry
	if( totalTimerNum >= 2 )
	{
		TAP_Timer_Delete( 0 );
	}

    return 0;
}


