#include "tap.h"

#define ID_DIRECTOSD 0x80000105

TAP_ID( ID_DIRECTOSD );
TAP_PROGRAM_NAME("DIRECTOSD");
TAP_AUTHOR_NAME("TOPFIELD");
TAP_DESCRIPTION("How to access OSD Memory");
TAP_ETCINFO(__DATE__);


bool _exitFlag = FALSE;

dword TAP_EventHandler( word event, dword param1, dword param2 )
{
    if( event == EVT_KEY )
    {
        _exitFlag = TRUE;
	    return 0;
    }
    return param1;
}

word *_vAddr[576];

int TAP_Main(void)
{
    dword i;
    dword x, y, t;
    
    TYPE_OsdBaseInfo osdBaseInfo;
    TAP_Osd_GetBaseInfo( &osdBaseInfo );

    // set vertical address
    for( i=0; i<576; i+=2 )
    {
        _vAddr[i] = osdBaseInfo.eAddr + 720*i;
        _vAddr[i+1] = osdBaseInfo.oAddr + 720*i;
    }

    t = 0;
    while( _exitFlag == FALSE )
    {
        // draw 
        for( y=0; y<576; y++ )
        {
            for( x=0; x<720; x++ )
            {
                *(_vAddr[y]+x) = RGB( (t+y)*0x1f/576, (t+x)*0x1f/720, (t+y+x)*0x1f/(720+576) );
            }
        }
        t+=2;
        
        TAP_SystemProc();
    }
    
    return 0;
}


